define([
    'backbone',
    'moment',
    'modules/new-appointment-request/resources/direct/clinics/collection',
    'modules/new-appointment-request/resources/direct/model',
    'modules/new-appointment-request/tests/helpers/general-helper',
], function(Backbone, moment, Collection, DirectModel, helpers) {
    'use strict';


    /**
     * Fake set of clinics
     * @return {[]}
     */
    function getMockClinicList() {
        return [
            {
                'siteCode': '523',
                'clinicId': '1',
                'clinicName': 'ZZ10B',
                'clinicFriendlyLocationName': 'Z Last',
                'primaryStopCode': '323',
                'secondaryStopCode': '350',
                'directSchedulingFlag': 'Y',
                'displayToPatientFlag': 'Y',
                'institutionName': 'BOSTON HCS VAMC',
                'institutionCode': '523',
                'objectType': 'CdwClinic',
                'link': [],
            }, {
                'siteCode': '523',
                'clinicId': '2',
                'clinicName': 'M Mid',
                'clinicFriendlyLocationName': '',
                'primaryStopCode': '323',
                'secondaryStopCode': '350',
                'directSchedulingFlag': 'Y',
                'displayToPatientFlag': 'Y',
                'institutionName': 'BOSTON HCS VAMC',
                'institutionCode': '523',
                'objectType': 'CdwClinic',
                'link': [],
            }, {
                'siteCode': '523',
                'clinicId': '3',
                'clinicName': '4B BO - Primary Care',
                'clinicFriendlyLocationName': 'A First',
                'primaryStopCode': '323',
                'secondaryStopCode': '179',
                'directSchedulingFlag': 'Y',
                'displayToPatientFlag': 'Y',
                'institutionName': 'BOSTON HCS VAMC',
                'institutionCode': '523',
                'objectType': 'CdwClinic',
                'link': [],
            },
        ];
    }


    /**
     * Generates two appointment slots:
     *     First -- dates[0] 8:00 - 8:30
     *     Second -- dates[1] 8:30 - 9:00
     * @param {array} dates two dates in MM/DD/YYYY
     * @return {[]}
     */
    function getAppointmentSlots(dates) {
        var _dates = dates || datesForSlots();
        return [
            {
                'startDateTime': _dates[0] + ' 08:00:00',
                'endDateTime': _dates[0] + ' 08:30:00',
                'bookingStatus': '1',
                'remainingAllowedOverBookings': '5',
                'availability': true,
            }, {
                'startDateTime': _dates[1] + ' 08:30:00',
                'endDateTime': _dates[1] + ' 09:00:00',
                'bookingStatus': '1',
                'remainingAllowedOverBookings': '5',
                'availability': true,
            },
        ];
    }

    /**
     * Generates two dates:
     *  First - One week from today
     *  Second - One month from today
     * @return {[]}
     */
    function datesForSlots() {
        var weekAsDays = 7;
        var today = moment();
        var nextWeek = today.add(weekAsDays, 'days').format('MM/DD/YYYY');
        var nextMonth = today.add(1, 'month').format('MM/DD/YYYY');
        return [nextWeek, nextMonth];
    }


    /**
     * Creates a basic Model that the Layout View knows how to uses.
     * @return {Backbone.Model}
     */
    function layoutModelFactory() {
        return new DirectModel({
            facility: new Backbone.Model({
                institutionCode: '12345',
            }),
        });
    }

    return helpers._.extend({}, helpers, {
        getMockClinicList: getMockClinicList,
        getAppointmentSlots: getAppointmentSlots,
        datesForSlots: datesForSlots,
        layoutModelFactory: layoutModelFactory,
    });
});
